/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaServicesBusyInterface;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;

public class MediaServicesUtil
implements MediaServicesErrorIds {
    private static final String TRACE_MASKT = "XMDAUTLT";
    private static final String TRACE_MASKF = "XMDAUTLF";
    private static final String TRACE_MASKD = "XMDAUTLD";
    private static FrameworkClassLogInfo LOGINFO = new FrameworkClassLogInfo(85, "MediaSvcUtil");
    private static final String MEDIA_SERVICES_MESSAGES_FILENAME = "com.ibm.hwmca.base.res.message";
    private PanelTasklet panelTasklet;
    private PanelTasklet busyPanelTasklet;
    private MediaServices mediaServices;
    private MediaDevice mediaDevice;
    private MediaDeviceIdentifier mediaDeviceIdentifier;
    private boolean busyDisplayed = false;
    public static final int MEDIA_DISKETTE = 1;
    public static final int MEDIA_CDROM = 2;
    public static final int MEDIA_DVDRAM = 3;
    public static final int MEDIA_HDPARTITION = 4;
    public static final int MEDIA_WRITABLE_MASS = 6;
    public static final int MEDIA_READONLY_MASS = 7;
    private LocalizableText title;
    private MessageText message;
    private LocalizableText answer;
    private static final String MEDIA_SERVICES_ERROR_TITLE = "MDA.MEDIA.SERVICES.ERROR.TITLE";
    private static final String MEDIA_SERVICES_ERROR_TEXT = "MDA.MEDIA.SERVICES.ERROR.TEXT";
    private static final String MEDIA_DEVICE_ERROR_TITLE = "MDA.MEDIA.SERVICES.DEVICE.ERROR.TITLE";
    private static final String MEDIA_DEVICE_ERROR_TEXT = "MDA.MEDIA.SERVICES.DEVICE.ERROR.TEXT";
    private static final String MEDIA_DEVICE_LOCKED_ERROR_TITLE = "MDA.MEDIA.SERVICES.DEVICE.LOCKED.ERROR.TITLE";
    private static final String MEDIA_DEVICE_LOCKED_ERROR_TEXT = "MDA.MEDIA.SERVICES.DEVICE.LOCKED.ERROR.TEXT";
    private static final String MEDIA_DEVICE_UNLOCK_ERROR_TITLE = "MDA.MEDIA.SERVICES.UNLOCK.MEDIA.ERROR.TITLE";
    private static final String MEDIA_DEVICE_UNLOCK_ERROR_TEXT = "MDA.MEDIA.SERVICES.DEVICE.ERROR.TEXT";
    private static final String MEDIA_DEVICE_NO_MEDIA_ERROR_TITLE = "MDA.MEDIA.SERVICES.NO.MEDIA.PRESENT.ERROR.TITLE";
    private static final String MEDIA_DEVICE_NO_MEDIA_ERROR_TEXT = "MDA.MEDIA.SERVICES.NO.MEDIA.PRESENT.ERROR.TEXT";
    private static final String MEDIA_MISSING_LABEL_ERROR_TITLE = "MDA.MEDIA.SERVICES.MEDIA.MISSING.LABEL.ERROR.TITLE";
    private static final String MEDIA_MISSING_LABEL_ERROR_TEXT = "MDA.MEDIA.SERVICES.MEDIA.MISSING.LABEL.ERROR.TEXT";
    private static final String MEDIA_INCORRECT_LABEL_ERROR_TITLE = "MDA.MEDIA.SERVICES.INCORRECT.MEDIA.LABEL.ERROR.TITLE";
    private static final String MEDIA_INCORRECT_LABEL_ERROR_TEXT = "MDA.MEDIA.SERVICES.INCORRECT.MEDIA.LABEL.ERROR.TEXT";
    private static final String MEDIA_WRITE_PROTECTED_ERROR_TITLE = "MDA.MEDIA.SERVICES.MEDIA.WRITE.PROTECTED.ERROR.TITLE";
    private static final String MEDIA_WRITE_PROTECTED_ERROR_TEXT = "MDA.MEDIA.SERVICES.MEDIA.WRITE.PROTECTED.ERROR.TEXT";
    private static final String MEDIA_INVALID_FILESYSTEM_ERROR_TITLE = "MDA.MEDIA.SERVICES.INVALID.FILESYSTEM.ERROR.TITLE";
    private static final String MEDIA_INVALID_FILESYSTEM_ERROR_TEXT = "MDA.MEDIA.SERVICES.INVALID.FILESYSTEM.ERROR.TEXT";
    private static final String MEDIA_SERVICES_BUSY_TITLE = "MDA.MEDIA.SERVICES.BUSY.TITLE";
    private static final String MEDIA_SERVICES_BUSY_TEXT = "MDA.MEDIA.SERVICES.BUSY.TEXT";

    public MediaServicesUtil(PanelTasklet panel) {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.MediaServicesUtil(panel = " + panel + ")");
        this.panelTasklet = panel;
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.MediaServicesUtil()");
    }

    public void setPanelTasklet(PanelTasklet panel) {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.setPanelTasklet()");
        this.panelTasklet = panel;
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.setPanelTasklet()");
    }

    public boolean isMessageBoxEnabled() {
        Trace.trace(TRACE_MASKT, "<> MediaServicesUtil.isMessageBoxEnabled()");
        return this.panelTasklet != null;
    }

    public MediaDevice getMediaDevice() throws MediaServicesUtilException {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.getMediaDevice()");
        if (this.mediaDevice == null) {
            throw new MediaServicesUtilException("Media device has not been prepared", 2, this.isMessageBoxEnabled());
        }
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.getMediaDevice()");
        return this.mediaDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaDeviceIdentifier queryMediaDevicePath(String filepath) throws MediaServicesUtilException {
        block7: {
            Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.queryMediaDevicePath(filepath = " + filepath + ")");
            try {
                this.showMediaServicesBusyDialog();
                try {
                    this.mediaServices = MediaServices.getMediaServices();
                    if (this.mediaServices != null) {
                        this.mediaDeviceIdentifier = this.mediaServices.queryMediaDevicePath(filepath);
                        break block7;
                    }
                    throw new MediaDeviceException("MediaServices object is null.");
                }
                catch (MediaDeviceException mediaDeviceException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.queryMediaDevicePath(): " + mediaDeviceException);
                    Trace.trace(TRACE_MASKF, mediaDeviceException);
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_ERROR_TEXT);
                        this.displayMediaMessageBox(this.title, this.message);
                    }
                    throw new MediaServicesUtilException(mediaDeviceException, 0, this.isMessageBoxEnabled());
                }
            }
            finally {
                this.destroyMediaServicesBusyDialog();
            }
        }
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.queryMediaDevicePath()");
        return this.mediaDeviceIdentifier;
    }

    /*
     * Exception decompiling
     */
    public MediaDevice prepareMedia(int mediaType, LocalizableText callerName) throws MediaServicesUtilException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MediaDevice prepareMedia(MediaDeviceIdentifier mediaDeviceId, LocalizableText callerName) throws MediaServicesUtilException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MediaDevice prepareMedia(int mediaType, LocalizableText callerName, boolean mountReadWrite, String label) throws MediaServicesUtilException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MediaDevice prepareMedia(MediaDeviceIdentifier mediaDeviceId, LocalizableText callerName, boolean mountReadWrite, String label) throws MediaServicesUtilException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void releaseMedia() throws MediaServicesUtilException {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.releaseMedia()");
        if (this.mediaDevice == null) {
            throw new MediaServicesUtilException("Cannot release a media device that is null", 2, this.isMessageBoxEnabled());
        }
        try {
            this.mediaDevice.unlock();
            this.mediaDevice = null;
        }
        catch (MediaDeviceLockException mediaDeviceLockException) {
            Trace.trace(TRACE_MASKF, "MediaServicesUtil.releaseMedia(): " + mediaDeviceLockException);
            Trace.trace(TRACE_MASKF, mediaDeviceLockException);
            this.mediaDevice = null;
            throw new MediaServicesUtilException(mediaDeviceLockException, 4, this.isMessageBoxEnabled());
        }
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.releaseMedia()");
    }

    private LocalizableText displayMediaMessageBox(LocalizableText title, MessageText message) {
        Trace.trace(TRACE_MASKF, "-> MediaServicesUtil.displayMediaMessageBox(title = " + title + ", " + "message = " + message + ")");
        LocalizableText answer = null;
        try {
            answer = this.panelTasklet.showMessageBox(true, title, message, null, null);
        }
        catch (TaskletException taskletException) {
            Trace.trace(TRACE_MASKF, "MediaServicesUtil.displayMediaMessageBox(): " + taskletException);
            Trace.trace(TRACE_MASKF, taskletException);
            new FrameworkLog(LOGINFO, 629, taskletException).log();
        }
        Trace.trace(TRACE_MASKF, "<- MediaServicesUtil.displayMediaMessageBox()");
        return answer;
    }

    private void showMediaServicesBusyDialog() {
        MediaServicesBusyInterface busyInterface;
        Trace.trace(TRACE_MASKF, "-> MediaServicesUtil.showMediaServicesBusyDialog()");
        if (this.panelTasklet != null && this.panelTasklet instanceof MediaServicesBusyInterface && (busyInterface = (MediaServicesBusyInterface)((Object)this.panelTasklet)).isBusyDesired()) {
            this.busyPanelTasklet = busyInterface.getPanelTasklet();
            if (this.busyPanelTasklet != null) {
                LocalizableText message = busyInterface.getBusyMessage();
                if (message == null) {
                    message = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_BUSY_TEXT);
                }
                try {
                    LocalizableText title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_BUSY_TITLE);
                    this.busyPanelTasklet.showBusyDialog(title, message);
                    this.busyDisplayed = true;
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, exc);
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- MediaServicesUtil.showMediaServicesBusyDialog()");
    }

    private void destroyMediaServicesBusyDialog() {
        Trace.trace(TRACE_MASKF, "-> MediaServicesUtil.destroyMediaServicesBusyDialog()");
        if (this.busyPanelTasklet != null && this.busyDisplayed) {
            try {
                this.busyPanelTasklet.destroyBusyDialog();
                this.busyDisplayed = false;
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        Trace.trace(TRACE_MASKF, "<- MediaServicesUtil.destroyMediaServicesBusyDialog()");
    }
}

